<?php

/*-------------------------------------------
  MAIAN MAIL v3.1
  Written by David Ian Bennett
  E-Mail: support@maianscriptworld.co.uk
  Website: www.maianscriptworld.co.uk
  This File: Main Parsing File
---------------------------------------------*/

error_reporting (E_ALL ^ E_NOTICE);

// Define installation path
define('SERVER_PATH', dirname(__FILE__).'/');
define ('PARENT',1);

// Load include files
include(SERVER_PATH.'inc/functions.php');
include(SERVER_PATH.'inc/config.inc.php');
include(SERVER_PATH.'lang/'.LANGFILE);
include(SERVER_PATH.'classes/php-captcha.inc.php');
include(SERVER_PATH.'classes/class_mail.inc.php');
include(SERVER_PATH.'classes/class_boxtrapper.inc.php');
include(SERVER_PATH.'lib/Savant2.php');

// Create instance of mail class and pass default vars
$MSW_MAIL             = new mailClass();
$MSW_MAIL->smtp       = SMTP;
$MSW_MAIL->smtp_host  = SMTP_HOST;
$MSW_MAIL->smtp_user  = SMTP_USER;
$MSW_MAIL->smtp_pass  = SMTP_PASS;
$MSW_MAIL->smtp_port  = SMTP_PORT;
$MSW_MAIL->addTag('{HOMEPAGE}', WEBSITE_NAME);
$MSW_MAIL->addTag('{HOMELINK}', HOMEPAGE_URL);
$MSW_MAIL->addTag('{PATH}', FORM_PATH);

// Create instance of box trapper class and pass default vars
$MSW_BT             = new boxTrapper();
$MSW_BT->whitelist  = WHITELIST_FILE;
$MSW_BT->duration   = DURATION;

// Run auto cron for box trapper
// Only run if enabled
if (BOXTRAPPER)
{
  $MSW_BT->autoCronBoxTrapper();
}

// Default vars
$cmd    = isset($_GET['cmd']) ? strip_tags($_GET['cmd']) : 'home';
$count  = 0;

switch ($cmd)
{
  case 'home':

  if (isset($_POST['process']))
  {
    $name       = cleanEvilTags($_POST['name']);
    $email      = cleanEvilTags($_POST['email']);
    $subject    = cleanEvilTags($_POST['subject']);
    $comments   = cleanEvilTags($_POST['comments']);
    $code       = (isset($_POST['code']) ? trim($_POST['code']) : '');

    // Now lets do error checking if enabled..

    if (NAME_CHECK)
    {
      if ($name=='')
      {
        $N_ERROR = true;
        $count++;
      }
    }

    if (EMAIL_CHECK)
    {
      if (!eregi("^([a-z]|[0-9]|\.|-|_)+@([a-z]|[0-9]|\.|-|_)+\.([a-z]|[0-9]){2,4}$", $email))
      {
        $E_ERROR = true;
        $count++;
      }
    }

    if (SUBJECT_CHECK)
    {
      if ($subject=='')
      {
        $S_ERROR = true;
        $count++;
      }
    }

    if (COMMENTS_CHECK)
    {
      if ($comments=='')
      {
        $C_ERROR = true;
        $count++;
      }
    }

    if (ENABLE_CAPTCHA)
    {
      if (!PhpCaptcha::Validate($code))
      {
        $CA_ERROR = true;
        $count++;
      }
    }

    // If count is 0, there are no errors, so send mail..
    // If there are errors, show form with error messages..

    if ($count==0)
    {
      $MSW_MAIL->addTag('{NAME}', $name);
      $MSW_MAIL->addTag('{EMAIL}', $email);
      $MSW_MAIL->addTag('{SUBJECT}', $subject);
      $MSW_MAIL->addTag('{COMMENTS}', $comments);
      $MSW_MAIL->addTag('{IP}', $_SERVER['REMOTE_ADDR']);
      $MSW_MAIL->addTag('{DATE}', date("j F Y"));

      // Is the box trapper enabled?
      // This was added in v3.1
      if (BOXTRAPPER)
      {
        // Assign unique code string
        // Pass to mail class
        $c_string      = $MSW_BT->randomCodeGenerator(10);
        $MSW_BT->code  = $c_string;
        $MSW_MAIL->addTag('{CODE}', $c_string);

        // If this address is in the whitelist, send mail
        if ($MSW_BT->checkEmailAddress($email))
        {
          // Send mail to webmaster..
          $MSW_MAIL->sendMail(WEBSITE_NAME,
                              EMAIL_ADDRESS,
                              WEBSITE_NAME,
                              EMAIL_ADDRESS,
                              $subject,
                              $MSW_MAIL->template('templates/email/webmaster.txt')
                              );

          // Send auto responder if enabled..
          if (AUTO_RESPONDER && $email)
          {
            $MSW_MAIL->sendMail($name,
                                $email,
                                WEBSITE_NAME,
                                EMAIL_ADDRESS,
                                str_replace("%w", WEBSITE_NAME, $auto),
                                $MSW_MAIL->template('templates/email/auto_responder.txt')
                                );
          }

          $displayMsg  = $thanks;
          $displayPage = 'thanks.tpl.php';
        }
        else
        {
          // Log message to box trapper folder and send mail for verification
          $MSW_BT->writeToDataFile($name,$email,$subject,$comments);

          $MSW_MAIL->sendMail($name,
                              $email,
                              WEBSITE_NAME,
                              EMAIL_ADDRESS,
                              $auto2,
                              $MSW_MAIL->template('templates/email/box_trapper.txt')
                              );

          $displayMsg  = $thanks2;
          $displayPage = 'thanks.tpl.php';
        }
      }
      else
      {
        // Send mail to webmaster..
        $MSW_MAIL->sendMail(WEBSITE_NAME,
                            EMAIL_ADDRESS,
                            WEBSITE_NAME,
                            EMAIL_ADDRESS,
                            $subject,
                            $MSW_MAIL->template('templates/email/webmaster.txt')
                            );

        // Send auto responder if enabled..
        if (AUTO_RESPONDER && $email)
        {
          $MSW_MAIL->sendMail($name,
                              $email,
                              WEBSITE_NAME,
                              EMAIL_ADDRESS,
                              str_replace("%w", WEBSITE_NAME, $auto),
                              $MSW_MAIL->template('templates/email/auto_responder.txt')
                              );
        }

        $displayMsg  = $thanks;
        $displayPage = 'thanks.tpl.php';
      }

      include(SERVER_PATH.'inc/header.php');

      $find     = array("%n", "%e", "%d");
      $replace  = array(cleanData($name), $email, DURATION);

      $tpl_thanks =& new Savant2();
      $tpl_thanks->assign('DATE', date("j F Y"));
      $tpl_thanks->assign('THANKS', str_replace($find,$replace,$displayMsg));
      $tpl_thanks->display('templates/'.$displayPage);

      include(SERVER_PATH.'inc/footer.php');

      exit;
    }
  }

  //---------------------------
  // Is the captcha enabled?
  //---------------------------

  $c_code = '';

  if (ENABLE_CAPTCHA)
  {
    $c_code = '<img src="index.php?cmd=captcha" alt="'.$field_sec_code.'" title="'.$field_sec_code.'" border="1"><br><br>
               <b>'.$field_code.'</b><br><br><input maxlength="7" class="formbox" type="text" name="code" value="" style="width:20%"> *'.(isset($CA_ERROR) ? '<br><span class="error">'.$field_code_error.'</span>' : '').'<br><br>';
  }

  include(SERVER_PATH.'inc/header.php');

  $tpl_index =& new Savant2();
  $tpl_index->assign('SCRIPT_NAME', '');
  $tpl_index->assign('DATE', date("j F Y"));
  $tpl_index->assign('ERROR_MSG', ($count>0 ? '<span class="error2">'.$field_error_msg.'</span><br><br>' : ''));
  $tpl_index->assign('NAME', $field_name);
  $tpl_index->assign('EMAIL', $field_email);
  $tpl_index->assign('SUBJECT', $field_subject);
  $tpl_index->assign('COMMENTS', $field_comments);
  $tpl_index->assign('SEND', $field_send);
  $tpl_index->assign('NAME_VALUE', (isset($name) ? cleanData($name) : ''));
  $tpl_index->assign('EMAIL_VALUE', (isset($email) ? cleanData($email) : ''));
  $tpl_index->assign('SUBJECT_VALUE', (isset($subject) ? cleanData($subject) : ''));
  $tpl_index->assign('COMMENTS_VALUE', (isset($comments) ? cleanData($comments) : ''));
  $tpl_index->assign('NAME_ERROR_CHECKING', (NAME_CHECK ? '*' : ''));
  $tpl_index->assign('EMAIL_ERROR_CHECKING', (EMAIL_CHECK ? '*' : ''));
  $tpl_index->assign('SUBJECT_ERROR_CHECKING', (SUBJECT_CHECK ? '*' : ''));
  $tpl_index->assign('COMMENTS_ERROR_CHECKING', (COMMENTS_CHECK ? '*' : ''));
  $tpl_index->assign('NAME_ERRORS', (isset($N_ERROR) ? '<br><span class="error">'.$field_name_error.'</span>' : ''));
  $tpl_index->assign('EMAIL_ERRORS', (isset($E_ERROR) ? '<br><span class="error">'.$field_email_error.'</span>' : ''));
  $tpl_index->assign('SUBJECT_ERRORS', (isset($S_ERROR) ? '<br><span class="error">'.$field_subject_error.'</span>' : ''));
  $tpl_index->assign('COMMENTS_ERRORS', (isset($C_ERROR) ? '<br><span class="error">'.$field_comments_error.'</span>' : ''));
  $tpl_index->assign('CAPTCHA', $c_code);
  $tpl_index->assign('SCRIPT_NAME', $script_name.' '.$script_version);
  $tpl_index->display('templates/index.tpl.php');

  include(SERVER_PATH.'inc/footer.php');
  break;

  // Case for box trapper verification
  // Added in v3.1

  case 'bt':

  $code = isset($_GET['code']) ? strip_tags($_GET['code']) : '';

  // Lets check the code var and make sure its alphanumeric
  if ($code=='' || !ereg("^[[:alnum:]]+$",$code))
  {
    exit;
  }

  // Check box trapper code to make sure file exists
  if (!$MSW_BT->getBoxTrapperData($code))
  {
    include(SERVER_PATH.'inc/header.php');

    $tpl_error =& new Savant2();
    $tpl_error->assign('DATE', date("j F Y"));
    $tpl_error->assign('ERROR', $error);
    $tpl_error->display('templates/error.tpl.php');

    include(SERVER_PATH.'inc/footer.php');
  }
  else
  {
    // Assign array data to variable
    // $data[0] = Name
    // $data[1] = Email
    // $data[2] = Subject
    // $data[3] = Comments
    $data = explode($MSW_BT->addSeperator(),$MSW_BT->getBoxTrapperData($code,true,false));

    // Pass data to mail class
    $MSW_MAIL->addTag('{NAME}', $data[0]);
    $MSW_MAIL->addTag('{EMAIL}', $data[1]);
    $MSW_MAIL->addTag('{SUBJECT}', $data[2]);
    $MSW_MAIL->addTag('{COMMENTS}', $data[3]);
    $MSW_MAIL->addTag('{IP}', $_SERVER['REMOTE_ADDR']);
    $MSW_MAIL->addTag('{DATE}', date("j F Y"));

    // Send message to webmaster
    $MSW_MAIL->sendMail(WEBSITE_NAME,
                        EMAIL_ADDRESS,
                        WEBSITE_NAME,
                        EMAIL_ADDRESS,
                        $data[2],
                        $MSW_MAIL->template('templates/email/webmaster.txt')
                        );

    // Send auto responder if enabled..
    if (AUTO_RESPONDER)
    {
      $MSW_MAIL->sendMail($data[0],
                          $data[1],
                          WEBSITE_NAME,
                          EMAIL_ADDRESS,
                          str_replace("%w", WEBSITE_NAME, $auto),
                          $MSW_MAIL->template('templates/email/auto_responder.txt')
                          );
    }

    // Add e-mail to whitelist
    $MSW_BT->writeToWhiteList($data[1]);

    // Delete box trapper message
    $MSW_BT->deleteBoxTrapperData($MSW_BT->getBoxTrapperData($code,true,true));

    // Show thanks page
    include(SERVER_PATH.'inc/header.php');

    $find     = array("%n", "%e", "%d");
    $replace  = array(cleanData($data[0]), $data[1], DURATION);

    $tpl_thanks =& new Savant2();
    $tpl_thanks->assign('DATE', date("j F Y"));
    $tpl_thanks->assign('THANKS', str_replace($find,$replace,$thanks));
    $tpl_thanks->display('templates/thanks.tpl.php');

    include(SERVER_PATH.'inc/footer.php');
  }

  break;

  case 'captcha':

  $MGC = new PhpCaptcha();
  $MGC->Create();

  break;
}
?>
